//34410A_34411A VISA and VCNET 2005 Sampled Measurements Example Program - This program 
// sets the 34410A or 34411A for 10 DCV measurements on the 10V range with a 1 second 
// delay between the measuremnts. The measurements are started with a BUS trigger (i.e., 
// software trigger). The program also checks the instrument id to make sure there is
// communication between the computer and instrument.
//
// For GPIB, the program uses the status byte to determine when measurements are made; 
// for USB and LAN, the program reads the Standard Event Register
//
// Included is an error checking routine to make sure the SCPI commands executed have
// the correct syntax.
//
// The program requires that the VISA drivers are installed in the computer. VISA 
// comes with the Agilent I/O Library. Also add the visa32.lib file as a resource and 
// include the visa.h file in the project.
//
// The program can use either GPIB, USB, or LAN to control the instrument. For GPIB, 
// use the appropriate VISA interface name (e.g., GPIB0, GPIB1, etc) and GPIB address
// (e.g., 9, 10, etc). For USB, use the correct interface name (e.g., USB0, USB1,
// etc) and ID string. Since the manufacturer's ID and instrument model code is
// already entered into the program, only the instrument serial number is required
// to run the program. For LAN, use the correct interface name (e.g., TCPIP0, TCPIP1,
// etc) and IP address of the instrument.
//
// The program was developed in Microsoft Visual C++ .NET 2005 as a WIN32 project.
//
//////////////////////////////////////////////////////////////////////////////////////
// Copyright  2006 Agilent Technologies Inc. All rights reserved.
//
// You have a royalty-free right to use, modify, reproduce and distribute this
// example files (and/or any modified version) in any way you find useful, provided
// that you agree that Agilent has no warranty, obligations or liability for any
// Sample Application Files.
//
// Agilent Technologies will not modify the program to provide added functionality or 
// construct procedures to meet your specific needs.
//////////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "34410A_34411A VISA and VCNET 2005 Sampled Measurements Example Program.h"
#include <windows.h>

using namespace VISAExample;

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	System::Threading::Thread::CurrentThread->ApartmentState = System::Threading::ApartmentState::STA;
	Application::Run(new VISAExampleForm());
	return 0;
}

